




/**********************************************************************************************
 *                                                                                            *
 * Ex2.      :   Using Command Read Hex Distance (RH and Rh)                                  *
 *               By Not Use Interupt Recive Hex Distance                                      *
 *                                                                                            *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 * Target MCU        : PIC18F8722 (ET-BASE PIC8722(ICD2))                                     *
 *                   : X-TAL : 10 MHz                                                         *
 *                   : CPU Clock = 40 MHz (x4)                                                *  
 *                                                                                            *
 * Editor-Compiler   : CCS Version 4.124                                                      *
 *                                                                                            *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                   *
 * Last Update       : 10/October/2014                                                        *
 *                                                                                            *
 * Port Interface    :  -- MCU-PIC-18F8722--           ---- ET-REMOTE DISTANCE ----           *
 *                                                                                            *
 *       UART1       :  RC6 = TX1          Connect         Rx(RS232 Port)                     *
 *                      RC7 = RX1          Connect         Tx(RS232 Port)                     *
 *                                                                                            *
 *                                                         Set JP-TTL/RS232 to RS232          *
 *                    Baud Rate = 57600 at Clock 40 Mhz    Set JP-BR (57600)                  *
 *                                                         Disable Filter                     *
 *                                                                                            *
 * Port LED       : RB0..RB7(Out)  Connect   LED Common Anode for Show Value Hex Cmm RH       *
 *                  RD0..RD7(Out)  Connect   LED Common Anode for Show result of Cmm Rh       *
 *                                                                                            *
 *                                        5V                                5V                *
 *                                       -+-                               -+-                *
 *                              \\        |                      \\         |                 * 
 *                   RB0--------|<|-------+         RD0---------|<|---------+                 *  
 *                         .              |                  .              |                 *
 *                         .              |                  .              |                 *
 *                         .              |                  .              |                 *                                                                                           
 *                         .    \\        |                  .   \\         |                 *
 *                   RB7-------|<|--------+         RD7---------|<|---------+                 *
 *                                                                                            * 
 *                                                                                            * 
 *   Operation    : Read Distance (RH-Cmm) Value Integer Out to LED Port RB ,                 *
 *                  Read Distance (Rh-Cmm) Value Integer+Point if Distance                    *
 *                  5.0-5.4 cm  LED Port RD0-RD3 ON ,if Distance 5.5-5.9 LED                  *
 *                  Port RD4-RD7 ON, Distance Other LED Port RB OFF                           *                                                                     
 *                                                                                            *
 **********************************************************************************************/
 

#include <18F8722.h>
#include <stdio.h>

#define TX1   PIN_C6
#define RX1   PIN_C7

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN          //Setup MCU
#use delay (clock = 40000000)                     //delay Clock = (ms)
#use rs232(baud = 57600, xmit = TX1, rcv = RX1)   //Set Rs232-CH1

#use fast_io(ALL)                                 //Stop Set direction Auto for All Port  by Compiler  


unsigned int8 distance[10]  ;

void Echo_Distance(int8 nm) ;
void UART1_Init(void)       ;


//-------------- Recive Echo Distance ----------------
//
//        nm : Number Data at Recive                 
//----------------------------------------------------

void Echo_Distance(int8 nm)
 {
 
   unsigned int8 m,ch ;  
   
     do
      {
        ch = getc()                              ; //Read data Start Byte
      }while(ch != '#')                          ; //Check Byte Start of Echo cmm('#')
     
      distance[0] = ch                           ; //keep byte start'#'
      nm--                                       ; //Decrease counter Recive Data  
     for(m=1;m<=nm;m++)                            //Loop keep Recive data all 
       {
         distance[m] = getch()                   ; //Keep data to buffer distance[] 
       }
   
 }

/*****************************************
 **       Function Initial UART1        **
 *****************************************/

void UART1_Init(void)
 {
   set_tris_C(0x80)             ;        //Set RX(RC7) = In,TX(RC6)=Out,RC5..RC0 = Out

 }

/********************************************************
 **                                                    **
 **                        MAIN                        **   
 **                                                    **
 ********************************************************/

 void main (void) 
  {
    unsigned int8 enter = 0x0D      ;
    float32 ds                      ;

    //---------------Initial Port I/O ----------------

    set_tris_B(0x00)                ;       //Set RB(0..7) = Output for LED Display  
    set_tris_D(0x00)                ;       //Set RD(0..7) = Output for LED Display  

    OUTPUT_B(0xFF)                  ;       //Set data 0xFF Default RB = LED OFF  
    OUTPUT_D(0xFF)                  ;       //Set data 0xFF Default RD = LED OFF  

    delay_ms(500)                   ;       //Wait Module ET-Remote Distance Ready when Power On
       
    UART1_Init()                    ;       //Initial Uart1 


//----------------- Start Sent Command Read Distance --------------

    while(true) 
    {   
      //################---- Sent Command RH ----#################

     //---For CMM RH Recive Data to Buffer Distance[] by Byte0 keep '#' ,Byte1 Keep Hex Distance or 0xFE(Error), 
     //                                                  Byte2 Keep  0x0D(Enter)
     
     
      printf("*RH=%c",enter)                         ;  //Sent Command Read Distance Hex Integer  
      
      Echo_Distance(3)                               ;  //Wait Recive data  3 Byte
      
      if((distance[0]=='#')&&(distance[2]==0x0D))       //Check '#' Start Byte and 0x0D for end Byte
      {  
         if(distance[1]== 0xFE)                         //Check data byte1 if is 0xFE(error)  :Distance is not between 3-210 cm
          {       
            OUTPUT_B(0xFF)                           ;  //LED Port-RB OFF
          }
         else    //Distance is between 3-210 cm.
          {       
            OUTPUT_B(~distance[1])                   ;  //Value Hex Distanc Display on LED PORT-RB  
          }          


         distance[0]=0;         //Clear Buffer keep Distance Byte Start and Byte end
         distance[2]=0;

      }
   
   
     //################---- Sent Command Rh ----#################

     //---For CMM Rh Recive Data to Buffer Distance[] by Byte0 keep '#' , Byte1 Keep Hex Distance Integer or 0xFE(Error), 
     //                                                  Byte2 keep Hex Distance point  , Byte3 Keep  0x0D(Enter)
     
     
      printf("*Rh=%c",enter)                          ;  //Sent Command Read Distance Hex Integer+Point   
      
      Echo_Distance(4)                                ;  //Wait Recive data  4 Byte
      
      if((distance[0]=='#')&&(distance[3]==0x0D))        //Check '#' Start Byte and 0x0D for end Byte
       {  
   
         if(distance[1]== 0xFE)                          //Check data byte1 if is 0xFE(error)  :Distance is not between 3-210 cm
          {           
            OUTPUT_D(0xFF)                            ;  //LED Port-RD OFF
          }
         else    //Distance is between 3-210 cm.
          {           
            ds = distance[1]+(float32)distance[2]/10  ;   //Total data integer+point keep in valiable float for use Calculate 

            if((ds>=5.0)&&(ds<= 5.4))                     //Check if Distance is 5.0-5.4 cm give LED RD0-RD3 ON
             {
               OUTPUT_D(0xF0)                         ;   //LED RD0..RD3 =ON
             }
            if((ds>=5.5)&&(ds<= 5.9))                     //Check if Distance is 5.5-5.9 cm. give LED PD4-PD7 ON
             { 
              OUTPUT_D(0x0F)                          ;   //LED RD4..RD7 =ON
             }
            if((ds<5.0)||(ds > 5.9))                      //Check if Distance less 5.0 cm. or more 5.9 cm. give LED RD0-RD7 OFF
             {
              OUTPUT_D(0xFF)                          ;   //LED RD0..RD7 =OFF
             }    
          } //else          

         distance[0]=0;         //Clear Buffer keep Distance Byte Start and Byte end
         distance[2]=0;

       } //if
    }//while
  }



